
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Mar 06 20:03:11 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_Ext_ATP_TST_RND_MAIN.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */

/***** Include Files ********/
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_Ext_ATP_RND_Acceptance.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include <stdio.h>

#if TST_USE_RND_DATA/*In case no test vectors are selected - code disabled*/
/******** Defines *******/
/******** Enums *******/
/******** Typedefs ******/
/******** Global Data *****/
/***** Private function prototype ***/
CRYSError_t CRYS_ExtApp_ATP_RND_Acceptance_ALL_TESTS(void);
/******** Public Functions ****/

void CRYS_ExtApp_ATP_RND_main(void)
{
  DxUint8_t  Var;
  do
   {
	   do
	   {
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n\n--[ Ext SEP application Random Number tests Menu ]---------"));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [1] - Random No reset          		  "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [2] - Random with reset               "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [T] - ALL RND Acceptance tests        "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [Z] - End of tests return to prev menu"));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n----------------------------------------\n\n"));
	           scanf("\n%c",&Var);
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Test = %c\n",Var));
	           if (Var<='Z')
	                    break;
	           else
	           {
	                 ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
	           }

	    }while(1);


	    switch(Var)
	    {
		  	case '1':
				    CRYS_Ext_ATP_RND_Acceptance_No_Reset();
				    break;
		  	case '2':
				    CRYS_Ext_ATP_RND_Reset();
				    break;
		  	case 'T':
				    CRYS_ExtApp_ATP_RND_Acceptance_ALL_TESTS ();
				    break;
	       	case 'Z':
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n End of RND tests \n"));
	                break ;
	       	default:
	              ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n* Error in test selection [%c]\n",Var));
	    }
	       if(Var =='Z')
	       break;
     }while (1);
}

/***************************
 * Function Name:
 * 	CRYS_ATP_TST_HASH_Acceptance_ALL_TESTS
 *
 * Inputs:
 * 	none
 *
 * Outputs:
 * 	CRYSError_t - Function error return
 *
 * Description:
 * This function runs all of the HASH Acceptance tests
 *
 **************************/
CRYSError_t CRYS_ExtApp_ATP_RND_Acceptance_ALL_TESTS(void)
{
    CRYSError_t TST_ATP_RND_Error = TESTPASS;

    TST_ATP_Error = CRYS_Ext_ATP_RND_Acceptance_No_Reset();
    TST_ATP_RND_Error = TST_ATP_RND_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_RND_Error != TESTPASS)
			    return 	TST_ATP_RND_Error;
    #endif

    TST_ATP_Error = CRYS_Ext_ATP_RND_Reset();
    TST_ATP_RND_Error = TST_ATP_RND_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_RND_Error != TESTPASS)
			    return 	TST_ATP_RND_Error;
    #endif


	/*Check if all tests pass*/
	if (TST_ATP_RND_Error != TESTPASS)
		{
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE RND TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
		}
		else
		{
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n \n**********************\n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*** ALL OF THE RND Acceptance TESTS PASS   :-)         ***\n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
		}
		return TST_ATP_RND_Error;
}

#endif

